--
-- file prepared: 15 May 2024 23:19:20.078, using fd633c
--
self_ID = "p39"
declare_plugin(self_ID,
{
	displayName = _("p39"),
	developerName = _("Half Science, the 'clay pigeon' series"),  --see artistic credits in the readme.txt

	image = "FC.bmp",
	installed = true,
	dirName = current_mod_path,
	fileMenuName = _("p39"),

	version = " ",
	state = "installed",
	info = _("The Bell P-39 Airacobra was one of the principal American fighters in service when the United States entered combat during World War II. It had an unusual layout, with the engine installed in the center fuselage, behind the pilot, and driving a tractor propeller in the nose through the use of a long shaft. It was also the first fighter fitted with a tricycle undercarriage. While its mid-engine placement was innovative, its engine was equipped with only a single-stage, single-speed supercharger, which resulted in the P-39 performing poorly above 17,000 feet (5,200 m) altitude. In both western Europe and the Pacific, the Airacobra found itself outclassed as an interceptor and was relegated to other duties, typically used at lower altitudes for such missions as ground strafing. The P-39 was also used by the Soviet Air Force, for which air combat often took place at medium and lower altitudes. Soviet P-39s had no trouble dispatching Junkers Ju 87 Stukas or German twin-engine bombers, and matched, and in some areas surpassed, early and mid-war Messerschmitt Bf 109s. Soviet pilots scored the highest number of kills attributed to any US fighter type flown by any air force in any conflict. Other major users of the type included the Free French, the Royal Air Force, and the Italian Co-Belligerent Air Force. (source: https://en.wikipedia.org/wiki/Bell_P-39_Airacobra) "),

	update_id = "p39",

	Skins =
	{
		{
			name = _("p39"),
			dir = "Theme"
		},
	},
	Missions =
	{
		{
			name = _("p39"),
			dir = "Missions",
		},
	},
	LogBook =
	{
		{
			name = _("p39"),
			type = "p39",
		},
	},
	InputProfiles =
	{
		["p39"] = current_mod_path .. '/Input/p39',
	},
})
----------------------------------------------------------------------------------------
mount_vfs_texture_path(current_mod_path.."/Textures")
mount_vfs_model_path(current_mod_path.."/Shapes")
dofile(current_mod_path.."/Views.lua")
dofile(current_mod_path.."/weapons.lua")
make_view_settings('p39', ViewSettings, SnapViews)
make_flyable('p39', current_mod_path..'/Cockpit/Scripts/', { nil, old = 54 }, current_mod_path..'/comm.lua')
dofile(current_mod_path..'/p39.lua')
------------------------------------------------------------------------------------ -
plugin_done()

